package gov.va.med.mhv.usermgmt.service;

import java.util.GregorianCalendar;
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;


public class JNDILdapTest {
	public static void main(String[] args){
		Hashtable envGC = new Hashtable(); 
		String adminName = "vhamaster\\vhaishmhvsa";
		String adminPassword = "!!MyHealth00";
 		String urlGC = "ldap://serverserv.abc.domain.ext:0000";
 		envGC.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
		envGC.put(Context.SECURITY_AUTHENTICATION,"simple");
		envGC.put(Context.SECURITY_PRINCIPAL,adminName);
		envGC.put(Context.SECURITY_CREDENTIALS,adminPassword);
		envGC.put(Context.PROVIDER_URL,urlGC);
					
		try {
			LdapContext ctxGC = new InitialLdapContext(envGC,null);  //Create the initial directory context
			SearchControls searchCtls = new SearchControls();  //Create the search controls for a search against the GC 
			searchCtls.setReturningAttributes(new String[]{"sAMAccountName","name","givenName","title","telephoneNumber","l","physicalDeliveryOfficeName","sn"}); //Specify the attributes to return
			searchCtls.setSearchScope(SearchControls.SUBTREE_SCOPE);//Specify the search scope
			searchCtls.setTimeLimit(0);
			
			String searchFilter = "(&(objectClass=user)(sn=s*))";    //last name search
			//String searchFilter = "(&(objectClass=user)(cn=Shrader, Jon))"; //full name search
			//String searchFilter = "(&(objectClass=user)(sAMAccountName=VHAISASHRADJ))"; //vhaid search
						
			//initialize counter to total the results
			int totalResults = 0; 
 
			//Search for objects in the GC using the filter
			GregorianCalendar startSearch = new GregorianCalendar();
			NamingEnumeration answer = ctxGC.search("DC=va,DC=gov", searchFilter, searchCtls);
			GregorianCalendar endSearch = new GregorianCalendar();
			System.out.println("Search Complete, Total Search Time: " + TimingHelper.calcDuration(startSearch,endSearch));

			//Loop through the search results
			GregorianCalendar startProcessing = new GregorianCalendar();
			while (answer.hasMoreElements()) {
				answer.next(); 
				totalResults++;
			}
			ctxGC.close(); 	
			GregorianCalendar endProcessing = new GregorianCalendar();
			
			System.out.println("Processing Complete, Total Processing Time: " + TimingHelper.calcDuration(startProcessing,endProcessing));
			System.out.println(totalResults + " were found and processed, " + "Total Time: " + TimingHelper.calcDuration(startSearch,endProcessing));
			System.out.println("All Done, Leaving Search At: " + new GregorianCalendar().getTime());
		} 
		catch (NamingException e) {
			System.err.println("Problem searching directory: " + e);
		}		  
	}
}